
int g_nCurControlsMode = -1;
int g_ControlsLngFile = -1;

object modlist;
ref modlistref;
string sOldModRow;

bool g_bToolTipStarted = false;

void InitInterface(string iniName)
{
	g_nCurControlsMode = -1;
	GameInterface.title = "titleOptions";
	g_ControlsLngFile = LanguageOpenFile("ControlsNames.txt");

	if( CheckAttribute(&InterfaceStates,"showGameMenuOnExit") && sti(InterfaceStates.showGameMenuOnExit) == true) {
		LoadGameOptions();
	} else {
		DeleteAttribute( &PlayerProfile, "name" );
		LoadGameOptions();
	}

	IReadVariableBeforeInit();
	SendMessage(&GameInterface,"ls",MSG_INTERFACE_INIT,iniName);
	IReadVariableAfterInit();

	SetControlsTabMode(1);

	SetEventHandler("exitCancel","ProcessCancelExit",0);
	SetEventHandler("InterfaceBreak","ProcessCancelExit",0);  // boal
	SetEventHandler("eTabControlPress","procTabChange",0);
	SetEventHandler("eventBtnAction","procBtnAction",0);
	SetEventHandler("eventKeyChange","procKeyChange",0);
//JA: GOF Mod options -->
	SetEventHandler("eventExitModOpt","ExitModOpt",0);
	SetEventHandler("eventShowModOpt", "ShowModOpt", 0);
	SetEventHandler("eventAcceptModOpts", "AcceptModOpts", 0);
	SetEventHandler("OnTableClick", "OnTableClick", 0);
	SetEventHandler("TableSelectChange", "TableSelectChange", 0);
	SetEventHandler("eventFullReinit", "DoFullReinit", 0);
//<-- JA
	SetEventHandler("CheckButtonChange","procCheckBoxChange",0);
	SetEventHandler("eSlideChange","procSlideChange",0);

	SetEventHandler("evntKeyChoose","procKeyChoose",0);
	SetEventHandler("ShowInfo", "ShowInfo", 0);
	SetEventHandler("MouseRClickUP","HideInfo",0);

	SetEventHandler("evFaderFrame","FaderFrame",0);

	aref ar; makearef(ar,objControlsState.key_codes);
	SendMessage(&GameInterface,"lsla",MSG_INTERFACE_MSG_TO_NODE,"KEY_CHOOSER", 0,ar);

	if( sti(Render.full_screen)==0 )
	{
		SetSelectable("GAMMA_SLIDE",false);
		SetSelectable("BRIGHT_SLIDE",false);
		SetSelectable("CONTRAST_SLIDE",false);
	}

	float ftmp1 = -1.0;
	float ftmp2 = -1.0;
	float ftmp3 = -1.0;
	SendMessage(&sound,"leee",MSG_SOUND_GET_MASTER_VOLUME,&ftmp1,&ftmp2,&ftmp3);
	if( ftmp1==-1.0 && ftmp2==-1.0 && ftmp3==-1.0 )
	{
		SetSelectable("MUSIC_SLIDE",false);
		SetSelectable("SOUND_SLIDE",false);
		SetSelectable("DIALOG_SLIDE",false);
	}
}

void ProcessCancelExit()
{
	LoadGameOptions();
	ProcessExit();
}

void ProcessOkExit()
{
	SaveGameOptions();
	ProcessExit();
	Event("eventChangeOption");

	// change sea settings
	SetSeaGridStep(stf(InterfaceStates.SeaDetails));
}

void ProcessExit()
{
	if( CheckAttribute(&InterfaceStates,"showGameMenuOnExit") && sti(InterfaceStates.showGameMenuOnExit) == true) {
		IDoExit(RC_INTERFACE_LAUNCH_GAMEMENU);
		return;
	}

	IDoExit(RC_INTERFACE_OPTIONSCREEN_EXIT);
	if( !CheckAttribute(&InterfaceStates,"InstantExit") || sti(InterfaceStates.InstantExit)==false ) {
		ReturnToMainMenu();
	}
}

void IDoExit(int exitCode)
{
	DelEventHandler("evntKeyChoose","procKeyChoose");
	DelEventHandler("eSlideChange","procSlideChange");
	DelEventHandler("CheckButtonChange","procCheckBoxChange");
	DelEventHandler("eventKeyChange","procKeyChange");
	DelEventHandler("eventBtnAction","procBtnAction");
	DelEventHandler("eTabControlPress","procTabChange");
	DelEventHandler("exitCancel","ProcessCancelExit");
	DelEventHandler("ShowInfo", "ShowInfo");
	DelEventHandler("MouseRClickUP","HideInfo");
	DelEventHandler("evFaderFrame","FaderFrame");
	DelEventHandler("InterfaceBreak","ProcessCancelExit");  // boal

	DelEventHandler("eventShowModOpt", "ShowModOpt");
	DelEventHandler("eventExitModOpt","ExitModOpt");
	DelEventHandler("eventAcceptModOpts", "AcceptModOpts");
	DelEventHandler("OnTableClick", "OnTableClick");
	DelEventHandler("TableSelectChange", "TableSelectChange");
	DelEventHandler("eventFullReinit", "DoFullReinit");

	LanguageCloseFile( g_ControlsLngFile );

	interfaceResultCommand = exitCode;
	if( CheckAttribute(&InterfaceStates,"InstantExit") && sti(InterfaceStates.InstantExit)==true ) {
		EndCancelInterface(true);
	} else {
		EndCancelInterface(false);
	}
	ControlsMakeInvert();
}

void IReadVariableBeforeInit()
{
	GetSoundOptionsData();
	GetMouseOptionsData();
	GetVideoOptionsData();
}

void IReadVariableAfterInit()
{
	GetHerbOptionsData();
	GetControlsStatesData();

	int nShowBattleMode = 0;
	if( CheckAttribute(&InterfaceStates,"ShowBattleMode") ) {
		nShowBattleMode = sti(InterfaceStates.ShowBattleMode);
	}
	SendMessage(&GameInterface,"lslll",MSG_INTERFACE_MSG_TO_NODE,"BATTLE_MODE_CHECKBOX", 2, 1, nShowBattleMode );

	int nSkipIntroMovies = 0;
	if( CheckAttribute(&InterfaceStates,"SkipIntroMovies") ) {
		nSkipIntroMovies = sti(InterfaceStates.SkipIntroMovies);
	}
	SendMessage(&GameInterface,"lslll",MSG_INTERFACE_MSG_TO_NODE,"SKIP_INTRO_CHECKBOX", 2, 1, nSkipIntroMovies );

	int nEnabledAutoSaveMode = 1;
	if( CheckAttribute(&InterfaceStates,"EnabledAutoSaveMode") ) {
		nEnabledAutoSaveMode = sti(InterfaceStates.EnabledAutoSaveMode);
	}
	SendMessage(&GameInterface,"lslll",MSG_INTERFACE_MSG_TO_NODE,"AUTOSAVE_CHECKBOX", 2, 1, nEnabledAutoSaveMode );

	int nEnabledQuestsMarks = 1;
	if( CheckAttribute(&InterfaceStates,"EnabledQuestsMarks") ) {
		nEnabledQuestsMarks = sti(InterfaceStates.EnabledQuestsMarks);
	}
	SendMessage(&GameInterface,"lslll",MSG_INTERFACE_MSG_TO_NODE,"QUESTMARK_CHECKBOX", 2, 1, nEnabledQuestsMarks );

	int nEnabledShipMarks = 1;
	if( CheckAttribute(&InterfaceStates,"EnabledShipMarks") ) {
		nEnabledShipMarks = sti(InterfaceStates.EnabledShipMarks);
	}
	SendMessage(&GameInterface,"lslll",MSG_INTERFACE_MSG_TO_NODE,"SHIPMARK_CHECKBOX", 2, 1, nEnabledShipMarks );

	int nEnabledSimpleSea = 0;
	if( CheckAttribute(&InterfaceStates,"SimpleSea") ) 
	{
		nEnabledSimpleSea = sti(InterfaceStates.SimpleSea);
	}
	SendMessage(&GameInterface,"lslll",MSG_INTERFACE_MSG_TO_NODE,"SIMPLESEA_CHECKBOX", 2, 1, nEnabledSimpleSea );
}

void SetControlsTabMode(int nMode)
{
	int nColor1 = argb(255,196,196,196);
	int nColor2 = nColor1;
	int nColor3 = nColor1;
	int nColor4 = nColor1;

	string sPic1 = "TabDeSelected";
	string sPic2 = sPic1;
	string sPic3 = sPic1;
	string sPic4 = sPic1;

	switch( nMode )
	{
	case 1: //    
		sPic1 = "TabSelected";
		nColor1 = argb(255,255,255,255);
	break;
	case 2: //    
		sPic2 = "TabSelected";
		nColor2 = argb(255,255,255,255);
	break;
	case 3: //   3- 
		sPic3 = "TabSelected";
		nColor3 = argb(255,255,255,255);
	break;
	case 4: //    
		sPic4 = "TabSelected";
		nColor4 = argb(255,255,255,255);
	break;
	}

	SetNewGroupPicture("TABBTN_SAILING_1ST", "TABS", sPic1);
	SetNewGroupPicture("TABBTN_PRIMARY_LAND", "TABS", sPic2);
	SetNewGroupPicture("TABBTN_SAILING_3RD", "TABS", sPic3);
	SetNewGroupPicture("TABBTN_FIGHT_MODE", "TABS", sPic4);
	SendMessage(&GameInterface,"lslll",MSG_INTERFACE_MSG_TO_NODE,"TABSTR_SAILING_1ST", 8,0,nColor1);
	SendMessage(&GameInterface,"lslll",MSG_INTERFACE_MSG_TO_NODE,"TABSTR_PRIMARY_LAND", 8,0,nColor2);
	SendMessage(&GameInterface,"lslll",MSG_INTERFACE_MSG_TO_NODE,"TABSTR_SAILING_3RD", 8,0,nColor3);
	SendMessage(&GameInterface,"lslll",MSG_INTERFACE_MSG_TO_NODE,"TABSTR_FIGHT_MODE", 8,0,nColor4);

	FillControlsList(nMode);
}

void procTabChange()
{
	int iComIndex = GetEventData();
	string sNodName = GetEventData();

	if( sNodName == "TABBTN_SAILING_1ST" ) {
		SetControlsTabMode( 1 );
		return;
	}
	if( sNodName == "TABBTN_PRIMARY_LAND" ) {
		SetControlsTabMode( 2 );
		return;
	}
	if( sNodName == "TABBTN_SAILING_3RD" ) {
		SetControlsTabMode( 3 );
		return;
	}
	if( sNodName == "TABBTN_FIGHT_MODE" ) {
		SetControlsTabMode( 4 );
		return;
	}
}

void procBtnAction()
{
	int iComIndex = GetEventData();
	string sNodName = GetEventData();

	if( sNodName == "BTN_OK" ) {
		if( iComIndex==ACTION_ACTIVATE || iComIndex==ACTION_MOUSECLICK ) {
			ProcessOkExit();
		}
		return;
	}
	if( sNodName == "BTN_CONTROLS_DEFAULT" ) {
		RestoreDefaultKeys();
		return;
	}
}

//Saint-Ashley - Added Re-Init Function

void Reinit()
{

//Saint-Ashley - Added Re-Init Function
//modified by Jonathan 
	if(LoadSegment("reinit.c"))
	{
		initReInit(false);
		UnloadSegment("reinit.c");
	}
}

void DoFullReinit()
{

//Saint-Ashley - Added Re-Init Function
//modified by Jonathan 
	if(LoadSegment("reinit.c"))
	{
		initReInit(true);
		UnloadSegment("reinit.c");
	}
}

//Saint-Ashley - Added Re-Init Function

void procCheckBoxChange()
{
	string sNodName = GetEventData();
	int nBtnIndex = GetEventData();
	int bBtnState = GetEventData();

	if( sNodName == "HERB_CHECKBOX" ) {
		if( bBtnState==true ) {
			switch( nBtnIndex ) {
			case 1: iGrassQuality=3; break;
			case 2: iGrassQuality=2; break;
			case 3: iGrassQuality=1; break;
			case 4: iGrassQuality=0; break;
			}
		}
		return;
	}
	if( sNodName == "ALWAYS_RUN_CHECKBOX" ) 
	{
		{ // always run
			SetAlwaysRun( bBtnState );
		}
	}
	if( sNodName == "INVERT_MOUSE_CHECKBOX" ) 
	{
		{ // invert mouse
			InterfaceStates.InvertCameras = bBtnState;
		}
	}
	if( sNodName == "BATTLE_MODE_CHECKBOX" ) 
	{
		{ // Show battle mode border
			InterfaceStates.ShowBattleMode = bBtnState;
		}
	}
	if( sNodName == "SKIP_INTRO_CHECKBOX" ) 
	{
		{ // Show battle mode border
			InterfaceStates.SkipIntroMovies = bBtnState;
		}
	}
	if( sNodName == "AUTOSAVE_CHECKBOX" ) 
	{
		{ // Show battle mode border
			InterfaceStates.EnabledAutoSaveMode = bBtnState;
		}
	}

	if( sNodName == "QUESTMARK_CHECKBOX" ) 
	{
		{ // Show battle mode border
			InterfaceStates.EnabledQuestsMarks = bBtnState;
		}
	}

	if( sNodName == "SHIPMARK_CHECKBOX" ) 
	{
		{ // Show battle mode border
			InterfaceStates.EnabledShipMarks = bBtnState;
		}
	}

	if( sNodName == "SIMPLESEA_CHECKBOX" ) 
	{
		{ // Show battle mode border
			InterfaceStates.SimpleSea = bBtnState;
		}
	}
}

void procSlideChange()
{
	string sNodeName = GetEventData();
	int nVal = GetEventData();
	float fVal = GetEventData();

	if( sNodeName=="GAMMA_SLIDE" || sNodeName=="BRIGHT_SLIDE" || sNodeName=="CONTRAST_SLIDE" ) {
		ChangeVideoColor();
		return;
	}
	if( sNodeName == "SEA_DETAILS_SLIDE" ) {
		ChangeSeaDetail();
		return;
	}
	if( sNodeName=="MUSIC_SLIDE" || sNodeName=="SOUND_SLIDE" || sNodeName=="DIALOG_SLIDE" ) {
		ChangeSoundSetting();
		return;
	}
	if( sNodeName=="VMOUSE_SENSITIVITY_SLIDE" || sNodeName=="HMOUSE_SENSITIVITY_SLIDE" ) {
		ChangeMouseSensitivity();
	}
}

void ChangeMouseSensitivity()
{
	InterfaceStates.mouse.x_sens = stf(GameInterface.nodes.hmouse_sensitivity_slide.value);
	InterfaceStates.mouse.y_sens = stf(GameInterface.nodes.vmouse_sensitivity_slide.value);
	SetRealMouseSensitivity();
}

void ChangeVideoColor()
{
	float fCurContrast = stf(GameInterface.nodes.contrast_slide.value);
	float fCurGamma = stf(GameInterface.nodes.GAMMA_SLIDE.value);
	float fCurBright = stf(GameInterface.nodes.BRIGHT_SLIDE.value);

	float fContrast = ConvertContrast(fCurContrast,false);
	float fGamma = ConvertGamma(fCurGamma,false);
	float fBright = ConvertBright(fCurBright,false);

	if( !CheckAttribute(&InterfaceStates,"video.contrast") ||
		(stf(InterfaceStates.video.contrast)!=fContrast) ||
		(stf(InterfaceStates.video.gamma)!=fGamma) ||
		(stf(InterfaceStates.video.brightness)!=fBright) ) {
			InterfaceStates.video.contrast = fContrast;
			InterfaceStates.video.gamma = fGamma;
			InterfaceStates.video.brightness = fBright;
			XI_SetColorCorrection(fContrast,fGamma,fBright);
	}
}

void ChangeSeaDetail()
{
	float fCurSeaDetail = stf(GameInterface.nodes.sea_details_slide.value);
	float fSeaDetail = ConvertSeaDetails(fCurSeaDetail,false);
	if( !CheckAttribute(&InterfaceStates,"SeaDetails") ||
		(stf(InterfaceStates.SeaDetails)!=fSeaDetail) ) {
			InterfaceStates.SeaDetails = fSeaDetail;
	}
}

void ChangeSoundSetting()
{
	float fMusic = stf(GameInterface.nodes.music_slide.value);
	float fSound = stf(GameInterface.nodes.sound_slide.value);
	float fDialog = stf(GameInterface.nodes.dialog_slide.value);
	SendMessage(&sound,"lfff", MSG_SOUND_SET_MASTER_VOLUME, fSound,	fMusic,	fDialog);
}

void FillControlsList(int nMode)
{
	int n,qC,idx;
	string groupName;
	aref arGrp, arC;

	if( nMode == g_nCurControlsMode ) {return;}
	g_nCurControlsMode = nMode;
	DeleteAttribute(&GameInterface,"controls_list");
	GameInterface.controls_list.select = 0;

	groupName = GetGroupNameByMode(nMode);
	if( CheckAttribute(&objControlsState,"keygroups."+groupName) ) {
		makearef(arGrp,objControlsState.keygroups.(groupName));
		qC = GetAttributesNum(arGrp);
		idx = 0;
		for( n=0; n<qC; n++ ) {
			arC = GetAttributeN(arGrp,n);
			if( false==CheckAttribute(arC,"invisible") || arC.invisible!="1" ) {
			//if( CheckAttribute(arC,"remapping") && arC.remapping=="1" ) {
				if( AddToControlsList( idx, GetAttributeName(arC), GetAttributeValue(arC), CheckAttribute(arC,"remapping") && arC.remapping=="1" ) ) {
					idx++;
				}
			}
		}
	}
	SendMessage( &GameInterface, "lsl", MSG_INTERFACE_MSG_TO_NODE, "CONTROLS_LIST", 0 );
}

bool AddToControlsList(int row, string sControl, string sKey, bool bRemapable)
{
	string rowname = "tr" + (row+1);
	GameInterface.controls_list.(rowname).userdata.remapable = bRemapable;
	GameInterface.controls_list.(rowname).userdata.control = sControl;
	GameInterface.controls_list.(rowname).userdata.key = sKey;
	GameInterface.controls_list.(rowname).td2.str = LanguageConvertString(g_ControlsLngFile,sControl);
	if( GameInterface.controls_list.(rowname).td2.str == "" ) {
		trace("Warning!!! " + sControl + " hav`t translate value");
	}
	if( !bRemapable ) { //     
		GameInterface.controls_list.(rowname).td2.color = argb(255,128,128,128);
	}
	if( CheckAttribute(&objControlsState,"key_codes."+sKey+".img") ) {
		GameInterface.controls_list.(rowname).td1.fontidx = 0;
		GameInterface.controls_list.(rowname).td1.textoffset = "2,-1";
		GameInterface.controls_list.(rowname).td1.scale = 0.5;
		GameInterface.controls_list.(rowname).td1.str = objControlsState.key_codes.(sKey).img;
	}
	return true;
}

string GetGroupNameByMode(int nMode)
{
	switch( nMode ) {
	case 1: return "Sailing1Pers"; break;
	case 2: return "PrimaryLand"; break;
	case 3: return "Sailing3Pers"; break;
	case 4: return "FightModeControls"; break;
	}
	return "unknown";
}

void GetSoundOptionsData()
{
	float fCurMusic = 0.5;
	float fCurSound = 0.5;
	float fCurDialog = 0.5;
	SendMessage(&sound,"leee",MSG_SOUND_GET_MASTER_VOLUME,&fCurSound,&fCurMusic,&fCurDialog);
	GameInterface.nodes.music_slide.value = fCurMusic;
	GameInterface.nodes.sound_slide.value = fCurSound;
	GameInterface.nodes.dialog_slide.value = fCurDialog;
}

void GetMouseOptionsData()
{
	float fCurXSens = 0.5;
	float fCurYSens = 0.5;
	if( CheckAttribute(&InterfaceStates,"mouse.x_sens") ) {fCurXSens=stf(InterfaceStates.mouse.x_sens);}
	if( CheckAttribute(&InterfaceStates,"mouse.y_sens") ) {fCurYSens=stf(InterfaceStates.mouse.y_sens);}
	if(fCurXSens<0.0) fCurXSens = 0.0;
	if(fCurXSens>1.0) fCurXSens = 1.0;
	if(fCurYSens<0.0) fCurYSens = 0.0;
	if(fCurYSens>1.0) fCurYSens = 1.0;
	GameInterface.nodes.hmouse_sensitivity_slide.value = fCurXSens;
	GameInterface.nodes.vmouse_sensitivity_slide.value = fCurYSens;
}

void GetVideoOptionsData()
{
	float fC = 1.0;
	float fG = 1.0;
	float fB = 0.0;
	float fD = 1.0;

	if( CheckAttribute(&InterfaceStates,"video.contrast") ) {
		fC = stf(InterfaceStates.video.contrast);
	}
	if( CheckAttribute(&InterfaceStates,"video.gamma") ) {
		fG = stf(InterfaceStates.video.gamma);
	}
	if( CheckAttribute(&InterfaceStates,"video.brightness") ) {
		fB = stf(InterfaceStates.video.brightness);
	}

	if( CheckAttribute(&InterfaceStates,"SeaDetails") ) {
		fD = stf(InterfaceStates.SeaDetails);
	}

	ISetColorCorrection( fC, fG, fB, fD );
}

void ISetColorCorrection(float fContrast, float fGamma, float fBright, float fSeaDetails)
{
	float fCurContrast = ConvertContrast(fContrast,true);
	float fCurGamma = ConvertGamma(fGamma,true);
	float fCurBright = ConvertBright(fBright,true);
	float fCurSeaDetails = ConvertSeaDetails(fSeaDetails, true);

	if(fCurContrast>1.0) fCurContrast = 1.0;
	if(fCurContrast<0.0) fCurContrast = 0.0;
	if(fCurGamma>1.0) fCurGamma = 1.0;
	if(fCurGamma<0.0) fCurGamma = 0.0;
	if(fCurBright>1.0) fCurBright = 1.0;
	if(fCurBright<0.0) fCurBright = 0.0;
	if(fCurSeaDetails<0.0) fCurSeaDetails = 0.0;
	if(fCurSeaDetails>1.0) fCurSeaDetails = 1.0;

	GameInterface.nodes.CONTRAST_SLIDE.value = fCurContrast;
	GameInterface.nodes.GAMMA_SLIDE.value = fCurGamma;
	GameInterface.nodes.BRIGHT_SLIDE.value = fCurBright;
	GameInterface.nodes.SEA_DETAILS_SLIDE.value = fCurSeaDetails;

	SendMessage(&GameInterface,"lslf",MSG_INTERFACE_MSG_TO_NODE,"CONTRAST_SLIDE", 0,fCurContrast);
	SendMessage(&GameInterface,"lslf",MSG_INTERFACE_MSG_TO_NODE,"GAMMA_SLIDE", 0,fCurGamma);
	SendMessage(&GameInterface,"lslf",MSG_INTERFACE_MSG_TO_NODE,"BRIGHT_SLIDE", 0,fCurBright);

	SendMessage(&GameInterface,"lslf",MSG_INTERFACE_MSG_TO_NODE,"SEA_DETAILS_SLIDE", 0, fCurSeaDetails);

	XI_SetColorCorrection(fContrast,fGamma,fBright);
	//Set sea detail
}

float ConvertContrast(float fContrast, bool Real2Slider)
{ //   0.75  1.25
	if(Real2Slider) {
		return fContrast*2.0-1.5;
	}
	return fContrast*0.5+0.75;
}

float ConvertGamma(float fGamma, bool Real2Slider)
{ //   0.5  2.0
	if(Real2Slider)
	{
		if(fGamma<=1.0) {return fGamma-0.5;}
		return fGamma*0.5;
	}
	if(fGamma<=0.5) {return fGamma+0.5;}
	return fGamma*2.0;
}

float ConvertBright(float fBright, bool Real2Slider)
{
	if(Real2Slider) {
		return (fBright+50.0)/100.0;
	}
	return fBright*100-50;
}

float ConvertSeaDetails(float fDetails, bool Real2Slider)
{
	return fDetails;
}

void GetHerbOptionsData()
{
	int nSelBtn = 0;
	switch( iGrassQuality ) {
	case 0: nSelBtn=4; break;
	case 1: nSelBtn=3; break;
	case 2: nSelBtn=2; break;
	case 3: nSelBtn=1; break;
	}
	SendMessage(&GameInterface,"lslll",MSG_INTERFACE_MSG_TO_NODE,"HERB_CHECKBOX", 2, nSelBtn, true );
}

void GetControlsStatesData()
{
	int nAlwaysRun = 0;
	if( CheckAttribute(&InterfaceStates,"alwaysrun") ) {
		nAlwaysRun = sti(InterfaceStates.alwaysrun);
	}
	int nInvertCam = 0;
	if( CheckAttribute(&InterfaceStates,"InvertCameras") ) {
		nInvertCam = sti(InterfaceStates.InvertCameras);
	}
	SendMessage(&GameInterface,"lslll",MSG_INTERFACE_MSG_TO_NODE,"ALWAYS_RUN_CHECKBOX", 2, 1, nAlwaysRun );
	SendMessage(&GameInterface,"lslll",MSG_INTERFACE_MSG_TO_NODE,"INVERT_MOUSE_CHECKBOX", 2, 1, nInvertCam );
}

void SetAlwaysRun(bool bRun)
{
	InterfaceStates.alwaysrun = bRun;
}

void procKeyChange()
{
	//FillControlsList();
	string srow = "tr" + GameInterface.controls_list.select;
	if( !CheckAttribute(&GameInterface,"controls_list."+srow) ) {return;}
	if( sti(GameInterface.controls_list.(srow).userdata.remapable)!=1 ) {return;}
	ChooseOtherControl();
}

void ChooseOtherControl()
{
	XI_WindowDisable("MAIN_WINDOW",true);
	XI_WindowShow("CHANGEKEY_WINDOW",true);
	SetCurrentNode("KEY_CHOOSER");
	string srow = "tr" + GameInterface.controls_list.select;
	SetFormatedText("CHANGEKEY_TEXT", XI_ConvertString("Press any key"));
	AddLineToFormatedText("CHANGEKEY_TEXT", " ");
	AddLineToFormatedText("CHANGEKEY_TEXT", GameInterface.controls_list.(srow).td2.str);
	AddLineToFormatedText("CHANGEKEY_TEXT", " ");
	AddLineToFormatedText("CHANGEKEY_TEXT", XI_ConvertString("KeyAlreadyUsed"));
	SendMessage(&GameInterface,"lslll",MSG_INTERFACE_MSG_TO_NODE,"CHANGEKEY_TEXT", 8, 0, argb(255,255,128,128) );
	SendMessage(&GameInterface,"lslll",MSG_INTERFACE_MSG_TO_NODE,"CHANGEKEY_TEXT", 8, 4, argb(0,255,64,64) );
	SendMessage(&GameInterface,"lsl",MSG_INTERFACE_MSG_TO_NODE,"CHANGEKEY_TEXT", 5);
}

int glob_retVal;
ref procKeyChoose()
{
	int keyIdx = GetEventData();
	int stickUp = GetEventData();

	glob_retVal = false;

	if (keyIdx == 7) {
		ReturnFromReassign();
		glob_retVal = true;
		return &glob_retVal;
	}

	if( DoMapToOtherKey(keyIdx,stickUp) )
	{
		ReturnFromReassign();
		glob_retVal = true;
	}

	return &glob_retVal;
}

void ReturnFromReassign()
{
	XI_WindowShow("CHANGEKEY_WINDOW",false);
	XI_WindowDisable("MAIN_WINDOW",false);
	SetCurrentNode("CONTROLS_LIST");
}

bool DoMapToOtherKey(int keyIdx,int stickUp)
{
	string srow = "tr" + GameInterface.controls_list.select;
	string groupName = GetGroupNameByMode( g_nCurControlsMode );
	string sControl = GameInterface.controls_list.(srow).userdata.control;
	string sKey = GameInterface.controls_list.(srow).userdata.key;


	aref arControlGroup;
	aref arKeyRoot,arKey;
	string tmpstr;
	int keyCode;

	if( stickUp )
	{
		//SetStickNotAvailable();
		return false;
	}

	makearef(arControlGroup,objControlsState.keygroups.(groupName));
	makearef(arKeyRoot,objControlsState.key_codes);
	arKey = GetAttributeN(arKeyRoot,keyIdx);
	keyCode = sti(GetAttributeValue(arKey));

	// check for not allowed keys
	if( //keyCode==sti(objControlsState.key_codes.VK_F1) ||
		keyCode==sti(objControlsState.key_codes.VK_F2) ||
		//keyCode==sti(objControlsState.key_codes.VK_F3) ||
		//keyCode==sti(objControlsState.key_codes.VK_F4) ||
		//keyCode==sti(objControlsState.key_codes.VK_F5) ||
		keyCode==sti(objControlsState.key_codes.VK_F6) ||
		//keyCode==sti(objControlsState.key_codes.VK_F7) ||
		keyCode==sti(objControlsState.key_codes.VK_F8) ||
		keyCode==sti(objControlsState.key_codes.VK_F9) )
	{
		return false;
	}

	if( CheckAttribute(arKey,"stick") && sti(arKey.stick)==true ) return false;

	if( KeyAlreadyUsed(groupName, sControl, GetAttributeName(arKey)) )
	{
		SetKeyChooseWarning( XI_ConvertString("KeyAlreadyUsed") );
		return false;
	}

	tmpstr = arControlGroup.(sControl);
	if( CheckAttribute(arKeyRoot,tmpstr+".stick") && sti(arKeyRoot.(tmpstr).stick)==true ) return false;

	int state = 0;
	if(CheckAttribute(arControlGroup,sControl+".state"))
	{	state = sti(arControlGroup.(sControl).state);	}

	CI_CreateAndSetControls( groupName,sControl,keyCode, state, true );
	GameInterface.controls_list.(srow).userdata.key = arKey;
	GameInterface.controls_list.(srow).td1.str = arKey.img;
	SendMessage( &GameInterface, "lsl", MSG_INTERFACE_MSG_TO_NODE, "CONTROLS_LIST", 0 );
	return true;
}

void RestoreDefaultKeys()
{
	SetMouseToDefault();
	ControlsInit(GetTargetPlatform(),false);

	int nMode = g_nCurControlsMode;
	g_nCurControlsMode = -1;
	FillControlsList(nMode);
}

void SetMouseToDefault()
{
	InterfaceStates.InvertCameras = false;
	InterfaceStates.mouse.x_sens = 0.5;
	InterfaceStates.mouse.y_sens = 0.5;

	SetRealMouseSensitivity();
	SetAlwaysRun(true);

	GetControlsStatesData();
	SendMessage(&GameInterface,"lslf",MSG_INTERFACE_MSG_TO_NODE,"VMOUSE_SENSITIVITY_SLIDE", 0,stf(InterfaceStates.mouse.y_sens));
	SendMessage(&GameInterface,"lslf",MSG_INTERFACE_MSG_TO_NODE,"HMOUSE_SENSITIVITY_SLIDE", 0,stf(InterfaceStates.mouse.x_sens));
}

void ShowInfo()
{
	g_bToolTipStarted = true;
	string sHeader = "TEST";
	string sNode = GetCurrentNode();

	string sText1, sText2, sText3, sPicture, sGroup, sGroupPicture;
	sPicture = "none";
	sGroup = "none";
	sGroupPicture = "none";

	switch (sNode)
	{
		case "GAMMA_SLIDE":
			sHeader = XI_ConvertString("gamma");
			sText1 = XI_ConvertString("gamma_descr");
			sText3 = XI_ConvertString("FullScreenOnly");
		break;
		case "BRIGHT_SLIDE":
			sHeader = XI_ConvertString("Brightness");
			sText1 = XI_ConvertString("brightness_descr");
			sText3 = XI_ConvertString("FullScreenOnly");
		break;
		case "CONTRAST_SLIDE":
			sHeader = XI_ConvertString("Contrast");
			sText1 = XI_ConvertString("Contrast_descr");
			sText3 = XI_ConvertString("FullScreenOnly");
		break;
		case "SEA_DETAILS_SLIDE":
			sHeader = XI_ConvertString("Sea Detail");
			sText1 = XI_ConvertString("Sea Detail_descr");
			sText2 = XI_ConvertString("ItCanRedusePerfomance");
			sText3 = XI_ConvertString("NeedToExitFromSea");
		break;

		case "HERB_CHECKBOX":
			sHeader = XI_ConvertString("Herb Quantity");
			sText1 = XI_ConvertString("Herb Quantity_descr");
			sText2 = XI_ConvertString("ItCanRedusePerfomance");
			//sText3 = XI_ConvertString("NeedToExitFromSea");
		break;

		case "MUSIC_SLIDE":
			sHeader = XI_ConvertString("Music Volume");
			sText1 = XI_ConvertString("Music Volume_descr");
		break;

		case "SOUND_SLIDE":
			sHeader = XI_ConvertString("Sound Volume");
			sText1 = XI_ConvertString("Sound Volume_descr");
		break;

		case "DIALOG_SLIDE":
			sHeader = XI_ConvertString("Dialog Volume");
			sText1 = XI_ConvertString("Dialog Volume_descr");
		break;

		case "ALWAYS_RUN_CHECKBOX":
			sHeader = XI_ConvertString("Always Run");
			sText1 = XI_ConvertString("Always Run_descr");
		break;

		case "INVERT_MOUSE_CHECKBOX":
			sHeader = XI_ConvertString("Invert Vertical Mouse Control");
			sText1 = XI_ConvertString("Invert Vertical Mouse Control_descr");
		break;

		case "VMOUSE_SENSITIVITY_SLIDE":
			sHeader = XI_ConvertString("Vertical Mouse Sensitivity");
			sText1 = XI_ConvertString("Vertical Mouse Sensitivity_descr");
		break;

		case "HMOUSE_SENSITIVITY_SLIDE":
			sHeader = XI_ConvertString("Horizontal Mouse Sensitivity");
			sText1 = XI_ConvertString("Horizontal Mouse Sensitivity_descr");
		break;

		case "BATTLE_MODE_CHECKBOX":
			sHeader = XI_ConvertString("Show battle mode");
			sText1 = XI_ConvertString("Show battle mode_descr");
		break;

		case "AUTOSAVE_CHECKBOX":
			sHeader = XI_ConvertString("AutoSave Mode");
			sText1 = XI_ConvertString("AutoSave Mode_descr");
		break;

		case "QUESTMARK_CHECKBOX":
			sHeader = XI_ConvertString("QuestMark Mode");
			sText1 = XI_ConvertString("QuestMark Mode_descr");
		break;

		case "SHIPMARK_CHECKBOX":
			sHeader = XI_ConvertString("ShipMark Mode");
			sText1 = XI_ConvertString("ShipMark Mode_descr");
		break;

		case "SIMPLESEA_CHECKBOX":
			sHeader = XI_ConvertString("SimpleSea Mode");
			sText1 = XI_ConvertString("SimpleSea Mode_descr");
		break;
	}

	CreateTooltip("#" + sHeader, sText1, argb(255,255,255,255), sText2, argb(255,255,192,192), sText3, argb(255,255,255,255), "", argb(255,255,255,255), sPicture, sGroup, sGroupPicture, 64, 64);
}

void HideInfo()
{
	if( g_bToolTipStarted ) {
		g_bToolTipStarted = false;
		CloseTooltip();
		SetCurrentNode("OK_BUTTON");
	}
}

bool KeyAlreadyUsed(string sGrpName, string sControl, string sKey)
{
	if( !CheckAttribute(&objControlsState,"keygroups."+sGrpName+"."+sControl) ) {return false;}
	if( objControlsState.keygroups.(sGrpName).(sControl) == sKey ) {return false;}

	bool bAlreadyUsed = false;
	int n,q, i,grp;
	aref arGrp,arCntrl, arGrpList;

	//       
	makearef(arGrp,objControlsState.keygroups.(sGrpName));
	q = GetAttributesNum(arGrp);
	for(n=0; n<q; n++)
	{
		arCntrl = GetAttributeN(arGrp,n);
		if( GetAttributeValue(arCntrl) == sKey ) {
			bAlreadyUsed = true;
			break;
		}
	}

	if( bAlreadyUsed ) {return bAlreadyUsed;}

	//        
	makearef(arGrpList, objControlsState.keygroups);
	grp = GetAttributesNum(arGrpList);
	for( i=0; i<grp; i++ )
	{
		arGrp = GetAttributeN(arGrpList,i);
		if( !CheckAttribute(arGrp,sControl) ) {continue;}

		q = GetAttributesNum(arGrp);
		for(n=0; n<q; n++)
		{
			arCntrl = GetAttributeN(arGrp,n);
			if( GetAttributeValue(arCntrl) == sKey ) {
				bAlreadyUsed = true;
				break;
			}
		}
		if( bAlreadyUsed ) {break;}
	}

	return bAlreadyUsed;
}

void SetKeyChooseWarning( string sWarningText )
{
	SendMessage(&GameInterface,"lslle",MSG_INTERFACE_MSG_TO_NODE,"CHANGEKEY_TEXT", 10, 4, &sWarningText );
	SendMessage( &GameInterface,"lsl",MSG_INTERFACE_MSG_TO_NODE,"CHANGEKEY_TEXT", 5 );
	SendMessage(&GameInterface,"lslll",MSG_INTERFACE_MSG_TO_NODE,"CHANGEKEY_TEXT", 8, 4, argb(255,255,64,64) );
	PostEvent("evFaderFrame",700,"lll",500,0,50);
}

void FaderFrame()
{
	int nTotalTime = GetEventData();
	int nCurTime = GetEventData();
	int nDeltaTime = GetEventData();

	nCurTime = nCurTime + nDeltaTime;
	if( nCurTime>nTotalTime ) {nCurTime=nTotalTime;}

	int nAlpha = 255*(nTotalTime-nCurTime) / nTotalTime;
	SendMessage(&GameInterface,"lslll",MSG_INTERFACE_MSG_TO_NODE,"CHANGEKEY_TEXT", 8, 4, argb(nAlpha,255,64,64) );

	if( nCurTime<nTotalTime ) {
		PostEvent("evFaderFrame",nDeltaTime,"lll",nTotalTime,nCurTime,nDeltaTime);
	}
}

// MOD OPTIONS SECTION

//TO ADD NEW OPTIONS:
//First edit _mod_on_off.h and add:
// #define NEW_MOD_NAME_OPT = 14   //(or next unused number)
// ModOpt[NEW_MOD_NAME_OPT] = 0;   //(or whatever default you want)

// Then edit option_screen.c
// Duplicate and edit a block of modlist.*optname*... in the SetupModList() Function
// Also add lines to the LoadCurModValues() and SetNewModValues() functions for your new option


void ShowModOpt() 
{
	// fill window
	SetupModList();
	LoadCurModValues();	
	InitModPage();
	
	XI_WindowShow("MOD_OPT_WINDOW", true);
	XI_WindowDisable("MOD_OPT_WINDOW", false);
	XI_WindowDisable("MAIN_WINDOW", true);
	SetCurrentNode("MOD_OPT_TABLE");

}

void ExitModOpt()
{
	XI_WindowShow("MOD_OPT_WINDOW", false);
	XI_WindowDisable("MOD_OPT_WINDOW", true);
	XI_WindowDisable("MAIN_WINDOW", false);
	SetCurrentNode("BTN_MOD_OPT");
}

void InitModPage() {
	SetFormatedText("MOD_OPT_DESCRIP_TEXT", "");
	aref aModDet;
	string row;

	int iOptCount = GetAttributesNum(modlistref)
	
	GameInterface.MOD_OPT_TABLE.hr.td1.str = "Mod Option";
	GameInterface.MOD_OPT_TABLE.hr.td2.str = "Curent Setting";

	for(int i=0; i<iOptCount; i++ ) {
		aModDet = GetAttributeN(modlistref,i);
		row = "tr" + (i + 1);
		GameInterface.MOD_OPT_TABLE.(row).td1.align = "left";
		GameInterface.MOD_OPT_TABLE.(row).td1.str = aModDet.name;
		GameInterface.MOD_OPT_TABLE.(row).td1.align = "left";
		GameInterface.MOD_OPT_TABLE.(row).td1.scale = 0.80;
		GameInterface.MOD_OPT_TABLE.(row).td2.str = GetCurValStr(aModDet);
		GameInterface.MOD_OPT_TABLE.(row).td2.scale = 0.80;
		//GameInterface.TABLE_SPECIAL.(row).td1.textoffset = "0,-6";
		GameInterface.MOD_OPT_TABLE.(row).userData.modref = GetAttributeName(aModDet);
	}
	Table_UpdateWindow("MOD_OPT_TABLE");

	ShowCurRowDet("tr1");
	sOldModRow = "tr1";
}

string GetCurValStr(aref aModDet) {
	int iVal = sti(aModDet.value);
	
	string sValName;
	sValName = GetOptValStr(aModDet, iVal);
	if (sValName == "") {
		//couldn't find a value, use default
		aModDet.value = aModDet.default;
		sValName = GetOptValStr(aModDet, iVal);
	} 
	return sValName;
} 

string GetOptValStr(aref aModDet, int iVal) {
	aref aOptList;
	string sOptNode;
	makearef(aOptList, aModDet.opts);   
	int iOptValsCount = GetAttributesNum(aOptList)
	
	for(int i=1; i<=iOptValsCount; i++ ) {
		sOptNode = "opt" + i;
		
		if (sti(aOptList.(sOptNode).value) == iVal) {
			aModDet.selOptNode = i; //record which opt matches the chosen val
			return aOptList.(sOptNode).name;
		}
	}
	return "";
}

void TableSelectChange()
{
	string sRow, sModRef, sDet;
	
	string sControl = GetEventData();
	int iRowSel = GetEventData();
	int iColSel = GetEventData();

	sRow = "tr" + (iRowSel);

	if (sRow != sOldModRow) {
		ShowCurRowDet(sRow);
		sOldModRow = sRow
	}
}

void ShowCurRowDet(string sRow) {
	string sModRef, sDet;

	sModRef = GameInterface.MOD_OPT_TABLE.(sRow).userData.modref;
	sDet = modlistref.(sModRef).description;
	SetFormatedText("MOD_OPT_DESCRIP_TEXT", sDet);
	GameInterface.MOD_OPT_TABLE.(sRow).speccolor = ARGB(120, 30, 30, 30);
	GameInterface.MOD_OPT_TABLE.(sOldModRow).speccolor = ARGB(0, 30, 30, 30);

	Table_UpdateWindow("MOD_OPT_TABLE");
}


void OnTableClick()
{
	string sControl = GetEventData();
	int iRowSel = GetEventData();
	int iColSel = GetEventData();

	if (iColSel == 2) {
		string sRow = "tr" + (iRowSel + 1);
		string sSelOpt = GameInterface.MOD_OPT_TABLE.(sRow).userdata.modref;
		//next val
		int iCurOpt = sti(modlist.(sSelOpt).selOptNode);
		int iNextNode = iCurOpt + 1;
		string sNextNode = "opt" + iNextNode;
		
		if (!CheckAttribute(modlist, sSelOpt + ".opts." + sNextNode)) {
			sNextNode = "opt1";
			iNextNode = 1;
		}

		modlist.(sSelOpt).value =modlist.(sSelOpt).opts.(sNextNode).value;
		modlist.(sSelOpt).selOptNode = iNextNode;
		GameInterface.MOD_OPT_TABLE.(sRow).td2.str = modlist.(sSelOpt).opts.(sNextNode).name;
		if (modlist.(sSelOpt).value != modlist.(sSelOpt).initvalue) {
			GameInterface.MOD_OPT_TABLE.(sRow).td2.color = ARGB(255,255,228,80);
		} else {
			GameInterface.MOD_OPT_TABLE.(sRow).td2.color = ARGB(255,255,255,255);
		}

		
		Table_UpdateWindow("MOD_OPT_TABLE");
	}
	
}

void SetupModList()
{
	
	makeref(modlistref, modlist);
	
	//fix for clearing old unused option from saved games
	if (CheckAttribute(modlist, "start_in_bermuda")) {
		DeleteAttribute(modlist, "start_in_bermuda");
	}
	
	modlist.realistic_spyglasses.name = "Realistic Spyglasses";
	modlist.realistic_spyglasses.description = "Turning this on will set telescopes to only showing realistic information and will give you a compass in place of the radar.  (GOF default)
Turn it off to get more details information about the target ship (COAS default)";
	modlist.realistic_spyglasses.opts.opt1.name = "On (Realistic)";
	modlist.realistic_spyglasses.opts.opt1.value = 1;
	modlist.realistic_spyglasses.opts.opt2.name = "Off (COAS Default)";
	modlist.realistic_spyglasses.opts.opt2.value = 0;
	modlist.realistic_spyglasses.default = 1;

	modlist.realistic_ship_purchase.name = "Realistic Ship Purchase";
	modlist.realistic_ship_purchase.description = "Turning this on will set shipyards to sell only ships they could realistically have. (GOF default)
Turn it off to be able to buy all sorts of ships from the shipyards (COAS default)";
	modlist.realistic_ship_purchase.opts.opt1.name = "On (Realistic)";
	modlist.realistic_ship_purchase.opts.opt1.value = 1;
	modlist.realistic_ship_purchase.opts.opt2.name = "Off (COAS Default)";
	modlist.realistic_ship_purchase.opts.opt2.value = 0;
	modlist.realistic_ship_purchase.default = 1;

	modlist.realistic_encounters.name = "Realistic Ship Encounters";
	modlist.realistic_encounters.description = "Turning this on will make the would map encounters more realistic. (GOF default)
Turn it off to use (COAS default)";
	modlist.realistic_encounters.opts.opt1.name = "On (Realistic)";
	modlist.realistic_encounters.opts.opt1.value = 1;
	modlist.realistic_encounters.opts.opt2.name = "Off (COAS Default)";
	modlist.realistic_encounters.opts.opt2.value = 0;
	modlist.realistic_encounters.default = 1;

	modlist.realistic_reloading.name = "Realistic Reloading";
	modlist.realistic_reloading.description = "Turning this on makes cannon reloading times slower and more realistic. (GOF default)  
Turn it off to have cannons reload at default quick speed (COAS default)
Note, with COAS setting, you could do more damage per second with 4 pounders then 48 pounders, abit needing to be at closer range.";
	modlist.realistic_reloading.opts.opt1.name = "On (Realistic)";
	modlist.realistic_reloading.opts.opt1.value = 1;
	modlist.realistic_reloading.opts.opt2.name = "Off (COAS Default)";
	modlist.realistic_reloading.opts.opt2.value = 0;
	modlist.realistic_reloading.default = 1;

	modlist.realistic_salaries.name = "Realistic Salaries";
	modlist.realistic_salaries.description = "Turning this on will increase the ship upkeep costs.  (GOF default)
Turn it off to use the default ship upkeep costs. (COAS default)";
	modlist.realistic_salaries.opts.opt1.name = "On (Realistic)";
	modlist.realistic_salaries.opts.opt1.value = 1;
	modlist.realistic_salaries.opts.opt2.name = "Off (COAS Default)";
	modlist.realistic_salaries.opts.opt2.value = 0;
	modlist.realistic_salaries.default = 1;

	modlist.realistic_cannon.name = "Realistic Cannon Damage";
	modlist.realistic_cannon.description = "This has three setting, realistic, which can take a long time to sink a ship (GOF default), default damage (COAS default), and in-between damage (half way between realistic, and the COAS default";
	modlist.realistic_cannon.opts.opt1.name = "Realistic";
	modlist.realistic_cannon.opts.opt1.value = 1;
	modlist.realistic_cannon.opts.opt2.name = "COAS Default";
	modlist.realistic_cannon.opts.opt2.value = 0;
	modlist.realistic_cannon.opts.opt3.name = "Inbetween";
	modlist.realistic_cannon.opts.opt3.value = 2;
	modlist.realistic_cannon.default = 1;

	modlist.realistic_weather.name = "Realistic Weather";
	modlist.realistic_weather.description = "Turning this on allows the wind to occasionally drop to 0. (GOF default)
Turn it off to have the wind never drop to 0 (COAS default)";
	modlist.realistic_weather.opts.opt1.name = "On (Realistic)";
	modlist.realistic_weather.opts.opt1.value = 1;
	modlist.realistic_weather.opts.opt2.name = "Off (COAS Default)";
	modlist.realistic_weather.opts.opt2.value = 0;
	modlist.realistic_weather.default = 1;

	modlist.realistic_weights.name = "Realistic Weights";
	modlist.realistic_weights.description = "Turning this on makes various ship goods and such weight more.  So a war ship with lots of ammunition can't also carry much cargo, and trading is less profitable. (GOF default)
Turn it off to have the weights set to the COAS default.";
	modlist.realistic_weights.opts.opt1.name = "On (Realistic)";
	modlist.realistic_weights.opts.opt1.value = 1;
	modlist.realistic_weights.opts.opt2.name = "Off (COAS Default)";
	modlist.realistic_weights.opts.opt2.value = 0;
	modlist.realistic_weights.default = 1;

	modlist.realistic_compass.name = "Realistic Compass";
	modlist.realistic_compass.description = "Turning this on will replace the Compass with one that doesn't have the radar and arrow for the wind direction forcing you to watch the flag for the wind direction and use your spyglass to search for the enemy.  (GOF default)
Turn it off to use the default Compass with the radar and arrow for the wind direction. (COAS default)";
	modlist.realistic_compass.opts.opt1.name = "On (Realistic)";
	modlist.realistic_compass.opts.opt1.value = 1;
	modlist.realistic_compass.opts.opt2.name = "Off (COAS Default)";
	modlist.realistic_compass.opts.opt2.value = 0;
	modlist.realistic_compass.default = 1;

	modlist.realistic_costs.name = "Realistic Costs";
	modlist.realistic_costs.description = "This alters the basic costs for the various ship goods, in general making things cheaper.  
Note: with both this and Realistic weights on, you will make much less profit on trade runs.";
	modlist.realistic_costs.opts.opt1.name = "On (Realistic)";
	modlist.realistic_costs.opts.opt1.value = 1;
	modlist.realistic_costs.opts.opt2.name = "Off (Default)";
	modlist.realistic_costs.opts.opt2.value = 0;
	modlist.realistic_costs.default = 0;
	modlist.realistic_costs.minor_mod_group = 1;
	
	modlist.less_close_encounters.name = "Fix Close Encounters";
	modlist.less_close_encounters.description = "This option means that now during all ship encounters, the distance of the encountered ships will reflect the distance on the world map.
This is in beta test as it can make some of the encountered ships end up jammed against an island, but the old system had you appearing right on top of them all the time near islands";
	modlist.less_close_encounters.opts.opt1.name = "On (Encounter at distance)";
	modlist.less_close_encounters.opts.opt1.value = 1;
	modlist.less_close_encounters.opts.opt2.name = "Off (COAS Default)";
	modlist.less_close_encounters.opts.opt2.value = 0;
	modlist.less_close_encounters.default = 0;

	modlist.no_distant_encounters.name = "No Distant Encounters";
	modlist.no_distant_encounters.description = "This option means that an encoutered ship will be in combat range.  So you can't just drop back to the world map.";
	modlist.no_distant_encounters.opts.opt1.name = "On (No distant encounters)";
	modlist.no_distant_encounters.opts.opt1.value = 1;
	modlist.no_distant_encounters.opts.opt2.name = "Off (COAS Default)";
	modlist.no_distant_encounters.opts.opt2.value = 0;
	modlist.no_distant_encounters.default = 0;

	modlist.perks_retroactive.name = "Perks Retroactive";
	modlist.perks_retroactive.description = "Turning this option on means that taking the perks Tree of life and Dynamo at any time will give you the HP/Energy bonus as if you had taken them at level 1.  So you don't need to take them straight away to get the best effect.";
	modlist.perks_retroactive.opts.opt1.name = "On (Retroactive bonus)";
	modlist.perks_retroactive.opts.opt1.value = 1;
	modlist.perks_retroactive.opts.opt2.name = "Off (COAS Default)";
	modlist.perks_retroactive.opts.opt2.value = 0;
	modlist.perks_retroactive.default = 0;
	modlist.perks_retroactive.minor_mod_group = 1;

	modlist.faster_combat_exp.name = "Spread Combat Experience";
	modlist.faster_combat_exp.description = "Turning this on means as you gain experience with your chosen fighting style (eg, light weapons) you will also gain a little experience with the other fighting styles.
	 This is off by default in both GOF and COAS";
	modlist.faster_combat_exp.opts.opt1.name = "On (Spread Experience)";
	modlist.faster_combat_exp.opts.opt1.value = 1;
	modlist.faster_combat_exp.opts.opt2.name = "Off (Default)";
	modlist.faster_combat_exp.opts.opt2.value = 0;
	modlist.faster_combat_exp.default = 0;
	modlist.faster_combat_exp.minor_mod_group = 1;

	modlist.less_powerful_skill_books.name = "Less powerful skill books";
	modlist.less_powerful_skill_books.description = "In the default GOF setup, you can stack various skill books to increase your skills by over 60%.  Turn this on to have them only stack to around 30%.";
	modlist.less_powerful_skill_books.opts.opt1.name = "On (Less powerful skill books)";
	modlist.less_powerful_skill_books.opts.opt1.value = 1;
	modlist.less_powerful_skill_books.opts.opt2.name = "Off (Default)";
	modlist.less_powerful_skill_books.opts.opt2.value = 0;
	modlist.less_powerful_skill_books.default = 0;
	modlist.less_powerful_skill_books.minor_mod_group = 1;

}

void LoadCurModValues() 
{
	//check new 
	
	modlist.realistic_spyglasses.value = REALISTIC_SPYGLASSES;
	modlist.realistic_ship_purchase.value = REALISTIC_SHIP_PURCHASE;
	modlist.realistic_reloading.value = Realistic_Reloading;
	modlist.realistic_salaries.value = REALISTIC_SALARIES;
	modlist.realistic_cannon.value = RTBL;
	modlist.realistic_encounters.value = REALISTIC_SHIP_ENCOUNTERS;
	modlist.realistic_weather.value = Realistic_Weather;
	modlist.realistic_weights.value = Realistic_Weights;
	modlist.realistic_compass.value = REALISTIC_COMPASS;
	modlist.realistic_costs.value = Realistic_Costs;
	modlist.faster_combat_exp.value = Faster_Combat_Exp;
	modlist.less_close_encounters.value = LessCloseEncounters;
	modlist.no_distant_encounters.value = No_Distant_Encounters;
	modlist.perks_retroactive.value = PerkRetroactive;
	modlist.less_powerful_skill_books.value = LowerSkillBooks;
	
	modlist.realistic_spyglasses.initvalue = REALISTIC_SPYGLASSES;
	modlist.realistic_ship_purchase.initvalue = REALISTIC_SHIP_PURCHASE;
	modlist.realistic_reloading.initvalue = Realistic_Reloading;
	modlist.realistic_salaries.initvalue = REALISTIC_SALARIES;
	modlist.realistic_cannon.initvalue = RTBL;
	modlist.realistic_encounters.initvalue = REALISTIC_SHIP_ENCOUNTERS;
	modlist.realistic_weather.initvalue = Realistic_Weather;
	modlist.realistic_weights.initvalue = Realistic_Weights;
	modlist.realistic_compass.initvalue = REALISTIC_COMPASS;
	modlist.realistic_costs.initvalue = Realistic_Costs;
	modlist.faster_combat_exp.initvalue = Faster_Combat_Exp;
	modlist.less_close_encounters.initvalue = LessCloseEncounters;
	modlist.no_distant_encounters.initvalue = No_Distant_Encounters;
	modlist.perks_retroactive.initvalue = PerkRetroactive;
	modlist.less_powerful_skill_books.initvalue = LowerSkillBooks;

	//new savegame compatible system

}

void setValFromInterfaceStates(string sModopt) {
	if (CheckAttribute(&InterfaceStates,sModopt)) {
		modlist.(sModopt).value = InterfaceStates.(sModopt);
	} else {
		modlist.(sModopt).value = modlist.(sModopt).default;
	}
	modlist.(sModopt).initvalue = modlist.(sModopt).value
}

void SetNewModValues()
{
	REALISTIC_SPYGLASSES = modlist.realistic_spyglasses.value;
	REALISTIC_SHIP_PURCHASE = modlist.realistic_ship_purchase.value;
	Realistic_Reloading = modlist.realistic_reloading.value;
	REALISTIC_SALARIES = modlist.realistic_Salaries.value;
	RTBL = modlist.realistic_cannon.value;
	REALISTIC_SHIP_ENCOUNTERS = modlist.realistic_encounters.value;
	Realistic_Weather = modlist.realistic_weather.value;
	Realistic_Weights = modlist.realistic_weights.value;
	REALISTIC_COMPASS = modlist.REALISTIC_COMPASS.value;
	Realistic_Costs = modlist.realistic_costs.value;
	Faster_Combat_Exp = modlist.faster_combat_exp.value;
	LessCloseEncounters = modlist.less_close_encounters.value;
	No_Distant_Encounters = modlist.no_distant_encounters.value;
	PerkRetroactive = modlist.perks_retroactive.value;
	LowerSkillBooks = modlist.less_powerful_skill_books.value;
}

void AcceptModOpts() {
	SetNewModValues();
	Reinit();
	ExitModOpt();	
}
